using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>05/12/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component implementing data persistence logic for task status. 
	///</summary>
		
	#endregion

	public class TestResult
	{		

		#region methods

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1246"> 
		///		<ExpectedInput>PatientOrder Guid</ExpectedInput>
		///		<ExpectedOutput>DataTable with test results</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1253"> 
		///		<ExpectedInput>Invalid guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>
		///	Returns DataTable containing test results for a specified patient within 
		///	a given division.
		///</summary>
		///<param name="patientOrderGuid">Patiend Order GUID</param>
		///<returns>DataTable containing test results for a given patient</returns>
		public static DataTable GetTestResults(Guid patientOrderGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetTestResults.patientorderguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetTestResults.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = patientOrderGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetTestResults.StoredProcName, prms);

			return ds.Tables[0];
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/26/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1254"> 
		///		<ExpectedInput>TestResult ID</ExpectedInput>
		///		<ExpectedOutput>DataTable with test result</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1255"> 
		///		<ExpectedInput>Invalid Id</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetTestResult
		/// </summary>
		/// <param name="testResultId"></param>
		/// <returns></returns>
		public static DataTable GetTestResult( string testResultId )
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetTestResult.testresultid, SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetTestResult.divisioncode, SqlDbType.Char)
			};

			prms[0].Value = testResultId;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			DataSet	ds = Common.StoredProcedure.GetData(STOREDPROC.GetTestResult.StoredProcName, prms);
			
			return ds.Tables[0];
		}

		#endregion
	}
}
